#!/bin/bash

if ! cd "/Library/Application Support/VMware Fusion/isoimages" > /dev/null 2>&1
then
   echo "Verzeichnis /Library/Application Support/VMware Fusion/isoimages nicht gefunden"
   exit 1
fi

if ! rm -dfR Originale > /dev/null 2>&1
then
   echo "Altes Sicherungsverzeichnis konnte nicht gelöscht werden"
   exit 2
fi

if ! mkdir Originale > /dev/null 2>&1
then
   echo "Verzeichnis Originale ließ sich nicht anlegen"
   exit 3
fi

if ! mv darwin.iso tools-key.pub *.sig Originale > /dev/null 2>&1
then
   echo "Verschieben der Originaldateien fehlgeschlagen"
   exit 4
fi

if ! perl -n -p -e 's/ServerVersion.plist/SystemVersion.plist/g' < Originale/darwin.iso > darwin.iso 2>&1
then
   echo "Modifikation von darwin.iso fehlerhaft"
   exit 5
fi

if ! openssl genrsa -out tools-priv.pem 2048 > /dev/null 2>&1
then
   echo "Fehler beim Anlegen des neuen Zertifikats"
   exit 6
fi

if ! openssl rsa -in tools-priv.pem -pubout -out tools-key.pub > /dev/null 2>&1
then
   echo "Erstellen des öffentlichen Schlüssels gescheitert"
   exit 7
fi

if ! for A in *.iso ; do openssl dgst -sha1 -sign tools-priv.pem < $A > $A.sig ; done
then
   echo "Probleme mit den Signaturen"
   exit 8
fi
